#ifndef __CTLSTRING_H
#define __CTLSTRING_H


#define REGEX_RESULT_MATCH    0
#define REGEX_RESULT_UNMATCH  1
#define REGEX_RESULT_ERROR   -1
#define WITH_DELIMITER     1
#define WITHOUT_DELIMITER  2

enum cmStrErrCode {
	CM_STR_ERRNO,
	CM_STR_NULL,
	CM_STR_REGEX,
	CM_GET_SUB_STRING_FAIL,
	CM_INVALID_NUM,
	CM_NOT_BUNDLED
};

int getLine(char *src, char *result, size_t max);
int matchRegex(char *str, char *pattern, int cflags);
int skipSpaceTab(char *str);
int truncateString(char *result, char *src, size_t max);
char *getSubString(char *line, int size, size_t max);
char *reallocChar(char *str, size_t size);
int extractString(char *result, char *src, char delim, int flg, size_t max);
char *trimString(char *str, size_t max);
void setCmStrErr(enum cmStrErrCode ecode, char *func, int line, char *msg);
char *addString(char *src, char *dest, size_t *dest_size, size_t increment);


#endif /* __CTLSTRING_H */

