/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef MAIN_WINDOW_INCLUDED
#define MAIN_WINDOW_INCLUDED

class Plot;
class Process;

#include <QMainWindow>
class QCloseEvent;
class QLineEdit;
class QListWidget;
class QListWidgetItem;
class QPushButton;
class QRadioButton;

class MainWindow : public QMainWindow
{
	Q_OBJECT

	public:
		MainWindow(QWidget *parent = 0);
		~MainWindow();

	private slots:
		void plot();
		void splot();
		void openDataFile();
		void save();
		void saveAs();
		void load();
		void rawCommand();
		void setPlotOptions();
		void fit();
		void set();
		void setSettingsAction();
		void console(bool visible);
		void whatsThis();
		void about();
		void addData();
		void setDataUp();
		void setDataDown();
		void deleteData();
		void setAddPushButton(const QString &text);
		void setAddPushButton(bool checked);
		void changeItem(QListWidgetItem *item);
		void setPushButton();

	private:
		// don't implement these
		MainWindow(const MainWindow &);
		MainWindow &operator=(const MainWindow &);

		void closeEvent(QCloseEvent *event);
		void setAction();
		Process *process;
		QList<Plot *> plotList;
		QString currentFile;
		QString currentDataFile;
		QRadioButton *filenameRadioButton;
		QLineEdit *filenameEdit;
		QRadioButton *functionRadioButton;
		QLineEdit *functionEdit;
		QPushButton *addPushButton;
		QPushButton *optionPushButton;
		QPushButton *upPushButton;
		QPushButton *downPushButton;
		QPushButton *deletePushButton;
		QListWidget *plotListWidget;
		QToolBar *toolBar;
		QAction *plotAct;
		QAction *splotAct;
		QAction *toolBarAct;
		QAction *consoleAct;
};
#endif // MAIN_WINDOW_INCLUDED
