/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef OPTION_DIALOG_INCLUDED
#define OPTION_DIALOG_INCLUDED

class OptionWidget;

#include <QBitArray>
#include <QDialog>
class QCloseEvent;
class QListWidget;
class QListWidgetItem;
class QDialog;
class QStackedWidget;

class OptionDialog : public QDialog
{
	Q_OBJECT

	public:
		static OptionDialog &instance(QWidget *parent = 0);
		static void destroyInstance();

    private slots:
		void accept();
		void apply();
		void reject();
		void init();
        void changePage(QListWidgetItem *current, QListWidgetItem *previous);
		void setModified();

	signals:
		void executed(const QString &command);

	private:
		OptionDialog(QWidget *parent = 0);
		// don't implement these
		OptionDialog(const OptionDialog &);
		OptionDialog &operator=(const OptionDialog &);

		void discard(OptionWidget *optionWidget);
		void closeEvent(QCloseEvent *e);
		static OptionDialog *instance_;
		QListWidget *contentsListWidget;
		QStackedWidget *pagesStackedWidget;
		QBitArray initBitArray;
};

#endif // OPTION_DIALOG_INCLUDED
