/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef FIT_BASIC_WIDGET_INCLUDED
#define FIT_BASIC_WIDGET_INCLUDED

#include <QWidget>
class QLineEdit;
class QRadioButton;

class FitBasicWidget : public QWidget
{
	Q_OBJECT

	public:
		FitBasicWidget(QWidget *parent = 0);

		void setFitFunction(const QString &function);
		QString fitFunction() const;

		void setFitDataFile(const QString &file);
		QString fitDataFile() const;

		void setFitParameterFile(bool isFile);
		bool isFitParameterFile() const;

		void setFitParameterFile(const QString &file);
		QString fitParameterFile() const;

		void setFitVariable(const QStringList &var);
		QStringList fitVariable() const;

		bool canFit() const;

	private slots:
		void openDataFile();
		void openParamFile();

	signals:
		void optionChanged();

	private:
		// don't implement these
		FitBasicWidget(const FitBasicWidget &);
		FitBasicWidget &operator=(const FitBasicWidget &);

		QString currentDataFile;
		QString currentParamFile;
		QLineEdit *functionLineEdit;
		QLineEdit *dataFileLineEdit;
		QRadioButton *paramFileRadioButton;
		QLineEdit *paramFileLineEdit;
		QRadioButton *paramCSLRadioButton;
		QLineEdit *paramCSLLineEdit;
};
#endif // PLOT_BASIC_WIDGET_INCLUDED
