/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef FIT_MODIFIER_WIDGET_INCLUDED
#define FIT_MODIFIER_WIDGET_INCLUDED

class FitModifier;

#include <QWidget>
class QCheckBox;
class QLineEdit;
class QSpinBox;

class FitModifierWidget : public QWidget
{
	Q_OBJECT

	public:
		FitModifierWidget(QWidget *parent = 0);

		void setFitModifier(const FitModifier &fitModifier);
		FitModifier fitModifier() const;

	private slots:
		void setIndex();

	private:
		// don't implement these
		FitModifierWidget(const FitModifierWidget &);
		FitModifierWidget &operator=(const FitModifierWidget &);

		static const int AXIS_NUM = 3;
		QLineEdit *columnLineEdit[AXIS_NUM];
		QLineEdit *formatLineEdit;
		QCheckBox *dataSetStartCheckBox;
		QSpinBox *dataSetStartSpinBox;
		QCheckBox *dataSetEndCheckBox;
		QSpinBox *dataSetEndSpinBox;
		QCheckBox *dataSetIncCheckBox;
		QSpinBox *dataSetIncSpinBox;
		QCheckBox *pointIncCheckBox;
		QSpinBox *pointIncSpinBox;
		QCheckBox *lineIncCheckBox;
		QSpinBox *lineIncSpinBox;
		QCheckBox *startPointCheckBox;
		QSpinBox *startPointSpinBox;
		QCheckBox *startLineCheckBox;
		QSpinBox *startLineSpinBox;
		QCheckBox *endPointCheckBox;
		QSpinBox *endPointSpinBox;
		QCheckBox *endLineCheckBox;
		QSpinBox *endLineSpinBox;
};
#endif // FIT_MODIFIER_WIDGET_INCLUDED
