/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "PlotTitleWidget.h"
#include "PlotTitle.h"

#include <QLineEdit>
#include <QGridLayout>
#include <QRadioButton>

PlotTitleWidget::PlotTitleWidget(QWidget *parent)
: QWidget(parent)
{
	setWindowTitle(tr("Title"));
	setWhatsThis(tr("plot {&lt;title-spec&gt;}"));

	defaultTitleRadioButton = new QRadioButton;
	defaultTitleRadioButton->setText(tr("&Default"));
	defaultTitleRadioButton->setChecked(true);

	noTitleRadioButton = new QRadioButton;
	noTitleRadioButton->setText(tr("&No Title"));

	customTitleRadioButton = new QRadioButton;
	customTitleRadioButton->setText(tr("C&ustom Title"));

	titleLineEdit = new QLineEdit;
	connect(customTitleRadioButton, SIGNAL(toggled(bool)),
			titleLineEdit, SLOT(setEnabled(bool)));

	QGridLayout *mainLayout = new QGridLayout;
	mainLayout->addWidget(defaultTitleRadioButton, 0, 0, 1, 2);
	mainLayout->addWidget(noTitleRadioButton, 1, 0, 1, 2);
	mainLayout->addWidget(customTitleRadioButton, 2, 0, 1, 2);
	mainLayout->addItem(new QSpacerItem(20, 20,
				QSizePolicy::Fixed, QSizePolicy::Minimum), 3, 0);
	mainLayout->addWidget(titleLineEdit, 3, 1);
	mainLayout->addItem(new QSpacerItem(20, 40,
				QSizePolicy::Minimum, QSizePolicy::Expanding), 4, 0);

	setLayout(mainLayout);
}

void PlotTitleWidget::setPlotTitle(const PlotTitle &plotTitle)
{
	bool isCustom;
	if (plotTitle.isNoTitle()) {
		noTitleRadioButton->setChecked(true);
		isCustom = false;
	} else if (plotTitle.title().isEmpty()) {
		defaultTitleRadioButton->setChecked(true);
		isCustom = false;
	} else {
		customTitleRadioButton->setChecked(true);
		titleLineEdit->setText(plotTitle.title());
		isCustom = true;
	}
	titleLineEdit->setEnabled(isCustom);
}

PlotTitle PlotTitleWidget::plotTitle() const
{
	PlotTitle plotTitle;
	if (noTitleRadioButton->isChecked()) {
		plotTitle.setNoTitle(true);
	} else if (customTitleRadioButton->isChecked()) {
		plotTitle.setTitle(titleLineEdit->text());
	}

	return plotTitle;
}
