/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "AxisLabel.h"

#include <QStringList>

const double AxisLabel::DEFAULT_FONT_SIZE = 0;
const int AxisLabel::DEFAULT_LINE_TYPE = 0;

const QString AxisLabel::AXIS[] = {
	"x", "y", "z", "x2", "y2", "cb", ""
};

AxisLabel::AxisLabel()
{
	for (int i = 0; !AXIS[i].isEmpty(); i++) {
		labelList.append("");
		xOffsetList.append(0.000000);
		yOffsetList.append(0.000000);
		fontNameList.append("");
		fontSizeList.append(DEFAULT_FONT_SIZE);
		lineTypeList.append(DEFAULT_LINE_TYPE);
	}
}

void AxisLabel::setLabel(int axis, const QString &label)
{
	labelList[axis] = label;
}

const QString &AxisLabel::label(int axis) const
{
	return labelList.at(axis);
}

void AxisLabel::setXOffset(int axis, double xoff)
{
	xOffsetList[axis] = xoff;
}

double AxisLabel::xOffset(int axis) const
{
	return xOffsetList.at(axis);
}

void AxisLabel::setYOffset(int axis, double yoff)
{
	yOffsetList[axis] = yoff;
}

double AxisLabel::yOffset(int axis) const
{
	return yOffsetList.at(axis);
}

void AxisLabel::setFontName(int axis, const QString &name)
{
	fontNameList[axis] = name;
}

const QString &AxisLabel::fontName(int axis) const
{
	return fontNameList.at(axis);
}

void AxisLabel::setFontSize(int axis, double size)
{
	fontSizeList[axis] = size;
}

double AxisLabel::fontSize(int axis) const
{
	return fontSizeList.at(axis);
}

void AxisLabel::setLineType(int axis, int lt)
{
	lineTypeList[axis] = lt;
}

int AxisLabel::lineType(int axis) const
{
	return lineTypeList.at(axis);
}

QString AxisLabel::command() const
{
	QStringList commandList;
	for (int i = 0; !AXIS[i].isEmpty(); i++) {
		QString str = "set " + AXIS[i] + "label"
			+ " \"" + labelList.at(i) + "\" " 
			+ QString::number(xOffsetList.at(i)) + "," 
			+ QString::number(yOffsetList.at(i))
			+ " font \"" + fontNameList.at(i);
		if (fontSizeList.at(i) != DEFAULT_FONT_SIZE) {
			str += "," + QString::number(fontSizeList.at(i));
		}
		str += "\"";
		if (lineTypeList.at(i) != DEFAULT_LINE_TYPE) {
			str += " textcolor lt " 
				+ QString::number(lineTypeList.at(i));
		}
		commandList << str;
	}
	return commandList.join("\n");
}
