/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef TERMINAL_LATEX_EMTEX_INCLUDED
#define TERMINAL_LATEX_EMTEX_INCLUDED

#include "Terminal.h"

#include <QString>

class TerminalLatexEmtex : public Terminal
{
	public:
		TerminalLatexEmtex();

		void setLatex(bool latex);
		bool isLatex() const;

		void setFontName(int name);
		int fontName() const;

		void setFontSize(int size);
		int fontSize() const;

	private:
		QString terminalOption() const;
		static const int DEFAULT_FONT_SIZE = 10;
		bool isLatex_;
		// default = 0x00, courier = 0x01, roman = 0x02
		int fontName_;
		int fontSize_;
};
#endif // TERMINAL_LATEX_EMTEX_INCLUDED
