/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "TerminalPbm.h"

TerminalPbm::TerminalPbm() : fontSize_(0), mode_(0)
{
	terminalType_ = "pbm";
}

void TerminalPbm::setFontSize(int size)
{
	fontSize_ = size;
}

int TerminalPbm::fontSize() const
{
	return fontSize_;
}

void TerminalPbm::setMode(int mode)
{
	mode_ = mode;
}

int TerminalPbm::mode() const
{
	return mode_;
}

QString TerminalPbm::terminalOption() const
{
	const QString SIZE[] = { "small", "medium", "large" };
	const QString MODE[] = { "monochrome", "gray", "color" };
	return SIZE[fontSize_] + " " + MODE[mode_];
}
