/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "ParametricOptionWidget.h"
#include "Parametric.h"

#include <QtGui/QGridLayout>
#include <QtGui/QCheckBox>

ParametricOptionWidget::ParametricOptionWidget(QWidget *parent)
: OptionWidget(parent), parametric(0)
{
	setWindowTitle(tr("Parameter"));
	setWhatsThis("set parametric");
}

ParametricOptionWidget::~ParametricOptionWidget()
{
	delete parametric;
}

void ParametricOptionWidget::construct()
{
	parametricCheckBox = new QCheckBox;
	parametricCheckBox->setText(tr("Parametric Functions"));
	connect(parametricCheckBox, SIGNAL(toggled(bool)),
			this, SIGNAL(modified()));

	QGridLayout *mainLayout = new QGridLayout;
	mainLayout->addWidget(parametricCheckBox, 0, 0);
	mainLayout->addItem(new QSpacerItem(40, 20, 
				QSizePolicy::Expanding, QSizePolicy::Minimum), 0, 1);
	mainLayout->addItem(new QSpacerItem(20, 40,
				QSizePolicy::Minimum, QSizePolicy::Expanding), 1, 0);

	setLayout(mainLayout);
}

void ParametricOptionWidget::init()
{
	delete parametric;
	parametric = new Parametric;
	setWidget();
}

void ParametricOptionWidget::apply()
{
	parametric->setParametric(parametricCheckBox->isChecked());
	emit executed(parametric->command());
}

void ParametricOptionWidget::setWidget()
{
	parametricCheckBox->setChecked(parametric->isParametric());
}
