/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "AxisData.h"

#include <QtCore/QStringList>

const QString AxisData::AXIS[] = {
	"x", "y", "z", "x2", "y2", "cb", ""
};

AxisData::AxisData()
{
	for (int i = 0; !AXIS[i].isEmpty(); i++) {
		timeList.append(false);
	}
}

void AxisData::setTime(int axis, bool time)
{
	timeList[axis] = time;
}

bool AxisData::isTime(int axis) const
{
	return timeList.at(axis);
}

QString AxisData::command() const
{
	QStringList commandList;
	for (int i = 0; !AXIS[i].isEmpty(); i++) {
		QString str = "set " + AXIS[i] + "data ";
		if (timeList.at(i)) {
			str += "time";
		}
		commandList << str;
	}
	return commandList.join("\n");
}
