/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2008 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef PLOT_OPTION_DIALOG_INCLUDED
#define PLOT_OPTION_DIALOG_INCLUDED

#include "Plot.h"
class PlotModifierWidget;
class PlotOthersWidget;
class PlotStyleWidget;
class PlotTitleWidget;

#include <QtGui/QDialog>
class QListWidget;
class QListWidgetItem;
class QStackedWidget;

//! plot コマンドのオプションを設定するダイアログ
class PlotOptionDialog : public QDialog
{
	Q_OBJECT

	public:
		explicit PlotOptionDialog(QWidget *parent = 0);

		/*!
		 * \brief Plot クラスのオブジェクトを設定する
		 * \param plot 設定するオブジェクト
		 */
		void setPlot(const Plot &plot);

	private slots:
		//! 設定を保存して、ダイアログを閉じる
		void accept();
		//! 設定を保存する
		void apply();
		//! 設定を破棄してダイアログを閉じる
		void reject();
		/*!
		 * \brief 表示する項目を変える
		 * \param current 現在の項目
		 * \param previous 前の項目
		 */
		void changePage(QListWidgetItem *current, QListWidgetItem *previous);

	signals:
		void optionChanged(const PlotOptionDialog &dialog, const Plot &plot);

	private:
		// don't implement these
		PlotOptionDialog(const PlotOptionDialog &);
		PlotOptionDialog &operator=(const PlotOptionDialog &);

		void closeEvent(QCloseEvent *e);
		//! 設定を破棄する
		void discard();
		//! オプションを設定する項目に対応するオブジェクト
		Plot plot_;
		QStackedWidget *pagesStackedWidget;
		QListWidget *contentsListWidget;
		PlotModifierWidget *plotModifierWidget;
		PlotOthersWidget *plotOthersWidget;
		PlotTitleWidget *plotTitleWidget;
		PlotStyleWidget *plotStyleWidget;
};
#endif // PLOT_OPTION_DIALOG_INCLUDED
