/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2008 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "FitRangeWidget.h"
#include "FitRange.h"

#include <QtGui/QLabel>
#include <QtGui/QLineEdit>
#include <QtGui/QGroupBox>
#include <QtGui/QVBoxLayout>

FitRangeWidget::FitRangeWidget(QWidget *parent)
: QWidget(parent)
{
	setWindowTitle(tr("Range"));
	setWhatsThis(tr("fit {[xrange] {[yrange]}}"));

	const QString RANGE[] = { "X", "Y" };
	QLabel *dummyVariableLabel[AXIS_NUM];
	QLabel *minimumLabel[AXIS_NUM];
	QLabel *maximumLabel[AXIS_NUM];
	QGridLayout *rangeLayout[AXIS_NUM];
	QGroupBox *rangeGroupBox[AXIS_NUM];
	QVBoxLayout *mainLayout = new QVBoxLayout;
	mainLayout->setMargin(0);
	for (int i = 0; i < AXIS_NUM; i++) {
		dummyVariableLabel[i] = new QLabel;
		dummyVariableLabel[i]->setText(tr("Variable name:"));

		dummyVariableLineEdit[i] = new QLineEdit;

		minimumLabel[i] = new QLabel;
		minimumLabel[i]->setText(tr("Min:"));

		minimumLineEdit[i] = new QLineEdit;

		maximumLabel[i] = new QLabel;
		maximumLabel[i]->setText(tr("Max:"));

		maximumLineEdit[i] = new QLineEdit;

		rangeLayout[i] = new QGridLayout;
		rangeLayout[i]->addWidget(dummyVariableLabel[i], 0, 0);
		rangeLayout[i]->addWidget(dummyVariableLineEdit[i], 0, 1);
		rangeLayout[i]->addItem(new QSpacerItem(40, 20, 
					QSizePolicy::Expanding, QSizePolicy::Minimum), 0, 2);
		rangeLayout[i]->addWidget(minimumLabel[i], 1, 0);
		rangeLayout[i]->addWidget(minimumLineEdit[i], 1, 1);
		rangeLayout[i]->addWidget(maximumLabel[i], 2, 0);
		rangeLayout[i]->addWidget(maximumLineEdit[i], 2, 1);

		rangeGroupBox[i] = new QGroupBox(RANGE[i] + tr(" Range"));
		rangeGroupBox[i]->setLayout(rangeLayout[i]);
		
		mainLayout->addWidget(rangeGroupBox[i]);
	}
	mainLayout->addStretch();

	setLayout(mainLayout);
}

void FitRangeWidget::setFitRange(const FitRange &fitRange)
{
	for (int i = 0; i < AXIS_NUM; i++) {
		dummyVariableLineEdit[i]->
			setText(fitRange.dummyVariable(i));
		minimumLineEdit[i]->setText(fitRange.minimum(i));
		maximumLineEdit[i]->setText(fitRange.maximum(i));
	}
}

FitRange FitRangeWidget::fitRange() const
{
	FitRange fitRange;
	for (int i = 0; i < AXIS_NUM; i++) {
		fitRange.setDummyVariable(i, dummyVariableLineEdit[i]->text());
		fitRange.setMinimum(i, minimumLineEdit[i]->text());
		fitRange.setMaximum(i, maximumLineEdit[i]->text());
	}
	return fitRange;
}
