/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef VIEW_OPTION_WIDGET_INCLUDED
#define VIEW_OPTION_WIDGET_INCLUDED

#include "OptionWidget.h"

class View;

class QCheckBox;
class QDoubleSpinBox;
class QLabel;

//! set view コマンドのオプションを扱うウィジェット
class ViewOptionWidget : public OptionWidget
{
	Q_OBJECT

	public:
		ViewOptionWidget(QWidget *parent = 0);
		~ViewOptionWidget();

		void construct();

	private:
		// don't implement these
		ViewOptionWidget(const ViewOptionWidget &);
		ViewOptionWidget &operator=(const ViewOptionWidget &);

		void init();
		void apply();
		void setWidget();
		View *view;
		QCheckBox *mapCheckBox;
		QDoubleSpinBox *rotationXDoubleSpinBox;
		QLabel *rotationXLabel;
		QDoubleSpinBox *rotationZDoubleSpinBox;
		QLabel *rotationZLabel;
		QDoubleSpinBox *scalingDoubleSpinBox;
		QLabel *scalingLabel;
		QDoubleSpinBox *scalingZDoubleSpinBox;
		QLabel *scalingZLabel;
};
#endif // VIEW_OPTION_WIDGET_INCLUDED
