/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "StyleData.h"

#include <QtCore/QString>

const QString StyleData::PLOTTING_STYLE[] = {
	"lines", "points", "linespoints", "dots", "impulses",
	"yerrorbars", "xerrorbars", "xyerrorbars", "steps", "fsteps",
	"histeps", "filledcurves", "boxes", "boxerrorbars", "boxxyerrorbars",
	"vectors", "financebars", "candlesticks", "errorlines", "xerrorlines",
	"yerrorlines", "xyerrorlines", "pm3d", ""
};


StyleData::StyleData() : plottingStyle_(1)
{
}

void StyleData::setPlottingStyle(int style)
{
	plottingStyle_ = style;
}

int StyleData::plottingStyle() const
{
	return plottingStyle_;
}

QString StyleData::command() const
{
	return "set style data " + PLOTTING_STYLE[plottingStyle_];
}
