# Copyright 1999-2009 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: $

inherit qt4 toolchain-funcs

DESCRIPTION="A GUI front-end to gnuplot"
HOMEPAGE="http://sourceforge.jp/projects/cueplot/"
SRC_URI="mirror://sourceforge.jp/cueplot/abcde/${P}.tar.bz2"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~ppc ~x86"
IUSE="linguas_ja"

DEPEND=">=x11-libs/qt-gui-4.2
		>=dev-util/cmake-2.4"
RDEPEND=">=x11-libs/qt-gui-4.2
		>=sci-visualization/gnuplot-4.0"

src_unpack() {
	unpack "${A}"
	cd "${S}"
}

src_compile() {
	if ! use linguas_ja; then
		sed -i -e '/REMOVE_ITEM/d' src/CMakeLists.txt
		sed -i -e 's:lang/qt_ja_JP.ts::' src/CMakeLists.txt
		sed -i -e 's:lang/cueplot_ja_JP.ts::' src/CMakeLists.txt
	fi

	cmake \
		-DCMAKE_INSTALL_PREFIX=/usr	\
		-DCMAKE_BUILD_TYPE=Release \
		-DBIN_INSTALL_DIR=/usr/bin \
		-DLIB_INSTALL_DIR=/usr/$(get_libdir) \
		-DXDG_INSTALL_DIR=/usr/share/applications \
		-DCMAKE_C_COMPILER=$(type -P $(tc-getCC)) \
		-DCMAKE_CXX_COMPILER=$(type -P $(tc-getCXX)) \
		|| die "cmake failed"

	emake || die "make failed"
}

src_install() {
	emake DESTDIR="${D}" install || die "make install failed"
}
