# from a source file of LabLux at revision 160
FIND_PROGRAM(QT_LUPDATE_EXECUTABLE NAMES lupdate lupdate-qt4 PATHS
		"[HKEY_CURRENT_USER\\Software\\Trolltech\\Qt3Versions\\4.0.0;InstallDir]/bin"
		"[HKEY_CURRENT_USER\\Software\\Trolltech\\Versions\\4.0.0;InstallDir]/bin"
		$ENV{QTDIR}/bin)

FIND_PROGRAM(QT_LRELEASE_EXECUTABLE NAMES lrelease lrelease-qt4 PATHS
		"[HKEY_CURRENT_USER\\Software\\Trolltech\\Qt3Versions\\4.0.0;InstallDir]/bin"
		"[HKEY_CURRENT_USER\\Software\\Trolltech\\Versions\\4.0.0;InstallDir]/bin"
		$ENV{QTDIR}/bin)

IF (APPLE)
	FIND_PROGRAM(SED_EXECUTABLE NAMES sed PATHS /usr/bin)
ENDIF (APPLE)

# QT4_WRAP_TS(outfiles infiles ...)
# outfiles receives .qm generated files from
# .ts files in arguments
# a target lupdate is created for you
# update/generate your translations files
# example: QT4_WRAP_TS(foo_QM ${foo_TS})

MACRO (QT4_WRAP_TS outfiles)
	# a target to manually run lupdate
	ADD_CUSTOM_TARGET(lupdate
		COMMAND ${QT_LUPDATE_EXECUTABLE} -silent ${CMAKE_CURRENT_SOURCE_DIR} 
		-ts ${ARGN} WORKING_DIRECTORY ${CMAKE_CURRENT_SOURCE_DIR})

	FOREACH (it ${ARGN})
		# for Japanese ts files
		IF (APPLE)
			GET_FILENAME_COMPONENT(filename ${it} NAME)
			# sed "s/(&amp;[[:upper:]])//" $it > file
			ADD_CUSTOM_COMMAND(OUTPUT
				${CMAKE_CURRENT_BINARY_DIR}/${filename}
				COMMAND ${SED_EXECUTABLE}
				ARGS "\"s/(&amp;[[:upper:]])//\"" ${it} 
				">" ${CMAKE_CURRENT_BINARY_DIR}/${filename}
				WORKING_DIRECTORY ${CMAKE_CURRENT_SOURCE_DIR}
				DEPENDS ${it})
			SET(tsfile ${CMAKE_CURRENT_BINARY_DIR}/${filename})
			SET(depfile ${tsfile})
		ELSE (APPLE)
			SET(tsfile ${CMAKE_CURRENT_SOURCE_DIR}/${it})
			SET(depfile ${it})
		ENDIF (APPLE)
		GET_FILENAME_COMPONENT(outfile ${it} NAME_WE)
		SET(outfile ${CMAKE_CURRENT_BINARY_DIR}/${outfile}.qm)
		ADD_CUSTOM_COMMAND(OUTPUT ${outfile}
			COMMAND ${QT_LRELEASE_EXECUTABLE}
			ARGS -silent ${tsfile} -qm ${outfile}
			DEPENDS ${depfile})
		SET(${outfiles} ${${outfiles}} ${outfile})
	ENDFOREACH (it)
ENDMACRO (QT4_WRAP_TS)
