/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "fitmodifier.h"

FitModifier::FitModifier()
{
}

void FitModifier::setM(int m)
{
	plotModifier.setM(m);
}

int FitModifier::m() const
{
	return plotModifier.m();
}

void FitModifier::setN(int n)
{
	plotModifier.setN(n);
}

int FitModifier::n() const
{
	return plotModifier.n();
}

void FitModifier::setP(int p)
{
	plotModifier.setP(p);
}

int FitModifier::p() const
{
	return plotModifier.p();
}

void FitModifier::setPointIncrement(int pointIncr)
{
	plotModifier.setPointIncrement(pointIncr);
}

int FitModifier::pointIncrement() const
{
	return plotModifier.pointIncrement();
}

void FitModifier::setBlockIncrement(int blockIncr)
{
	plotModifier.setBlockIncrement(blockIncr);
}

int FitModifier::blockIncrement() const
{
	return plotModifier.blockIncrement();
}

void FitModifier::setStartPoint(int startPoint)
{
	plotModifier.setStartPoint(startPoint);
}

int FitModifier::startPoint() const
{
	return plotModifier.startPoint();
}

void FitModifier::setStartBlock(int startBlock)
{
	plotModifier.setStartBlock(startBlock);
}

int FitModifier::startBlock() const
{
	return plotModifier.startBlock();
}

void FitModifier::setEndPoint(int endPoint)
{
	plotModifier.setEndPoint(endPoint);
}

int FitModifier::endPoint() const
{
	return plotModifier.endPoint();
}

void FitModifier::setEndBlock(int endBlock)
{
	plotModifier.setEndBlock(endBlock);
}

int FitModifier::endBlock() const
{
	return plotModifier.endBlock();
}

void FitModifier::setEntry(int axis, const QString &entry)
{
	plotModifier.setEntry(axis, entry);
}

const QString &FitModifier::entry(int axis) const
{
	return plotModifier.entry(axis);
}

void FitModifier::setFormat(const QString &format)
{
	plotModifier.setFormat(format);
}

const QString &FitModifier::format() const
{
	return plotModifier.format();
}

QString FitModifier::option() const
{
	return plotModifier.option();
}
