/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "fitrange.h"

FitRange::FitRange()
{
}

void FitRange::setDummyVariable(int axis, const QString &var)
{
	plotRange.setDummyVariable(axis + 1, var);
}

const QString &FitRange::dummyVariable(int axis) const
{
	return plotRange.dummyVariable(axis + 1);
}

void FitRange::setMinimum(int axis, const QString &min)
{
	plotRange.setMinimum(axis + 1, min);
}

const QString &FitRange::minimum(int axis) const
{
	return plotRange.minimum(axis + 1);
}

void FitRange::setMaximum(int axis, const QString &max)
{
	plotRange.setMaximum(axis + 1, max);
}

const QString &FitRange::maximum(int axis) const
{
	return plotRange.maximum(axis + 1);
}

QString FitRange::option() const
{
	return plotRange.option();
}
