/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2009 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "plotmodifier.h"

const QString PlotModifier::SMOOTH[] = { "unique", "frequency", "csplines",
	"acsplines", "bezier", "sbezier", ""
};

PlotModifier::PlotModifier() : m_(-1), n_(-1), p_(-1), smooth_(-1)
{
	for (int i = 0; i < EVERY_NUM; i++) {
		everyArray[i] = -1;
	}
	for (int i = 0; i < AXIS_NUM; i++) {
		entry_ << "";
	}
}

void PlotModifier::setM(int m)
{
	m_ = m;
}

int PlotModifier::m() const
{
	return m_;
}

void PlotModifier::setN(int n)
{
	n_ = n;
}

int PlotModifier::n() const
{
	return n_;
}

void PlotModifier::setP(int p)
{
	p_ = p;
}

int PlotModifier::p() const
{
	return p_;
}

void PlotModifier::setPointIncrement(int pointIncr)
{
	everyArray[0] = pointIncr;
}

int PlotModifier::pointIncrement() const
{
	return everyArray[0];
}

void PlotModifier::setBlockIncrement(int blockIncr)
{
	everyArray[1] = blockIncr;
}

int PlotModifier::blockIncrement() const
{
	return everyArray[1];
}

void PlotModifier::setStartPoint(int startPoint)
{
	everyArray[2] = startPoint;
}

int PlotModifier::startPoint() const
{
	return everyArray[2];
}

void PlotModifier::setStartBlock(int startBlock)
{
	everyArray[3] = startBlock;
}

int PlotModifier::startBlock() const
{
	return everyArray[3];
}

void PlotModifier::setEndPoint(int endPoint)
{
	everyArray[4] = endPoint;
}

int PlotModifier::endPoint() const
{
	return everyArray[4];
}

void PlotModifier::setEndBlock(int endBlock)
{
	everyArray[5] = endBlock;
}

int PlotModifier::endBlock() const
{
	return everyArray[5];
}

void PlotModifier::setEntry(int axis, const QString &entry)
{
	Q_ASSERT_X(axis >= 0 && axis < AXIS_NUM,
		"PlotModifier::setEntry", "index out of range");
	entry_[axis] = entry;
}

const QString &PlotModifier::entry(int axis) const
{
	Q_ASSERT_X(axis >= 0 && axis < AXIS_NUM,
		"PlotModifier::entry", "index out of range");
	return entry_.at(axis);
}

void PlotModifier::setFormat(const QString &format)
{
	format_ = format;
}

const QString &PlotModifier::format() const
{
	return format_;
}

void PlotModifier::setSmooth(int smooth)
{
	smooth_ = smooth;
}

int PlotModifier::smooth() const
{
	return smooth_;
}

QString PlotModifier::option() const
{
	QString str;
	// index
	if (m_ >= 0) {
		str += "index " + QString::number(m_);
		if (n_ >= 0) {
			str += ':' + QString::number(n_);
			if (p_ > 0) {
				str += ':' + QString::number(p_);
			}
		}
		str += ' ';
	}
	// every
	QString everyStr;
	bool flag = false;
	for (int i = 0; i < EVERY_NUM; i++) {
		if (everyArray[i] >= 0) {
			everyStr += QString::number(everyArray[i]);
			flag = true;
		}
		everyStr += ':';
	}
	if (flag) {
		while (everyStr.endsWith(':')) {
			everyStr.chop(1);
		}
		str += "every " + everyStr + ' ';
	}
	// using
	int index = 0;
	flag = true;
	for (int i = 0; i < AXIS_NUM; i++) {
		if (entry_[i].isEmpty()) {
			index = i;
			flag = false;
			break;
		}
	}
	if (flag) {
		index = AXIS_NUM;
	}
	if (index > 0 || !format_.isEmpty()) {
		str += "using ";
		for (int i = 0; i < index; i++) {
			str += entry_[i] + ':';
		}
		if (str.endsWith(':')) {
			str.chop(1);
			str += ' ';
		}
		if (!format_.isEmpty()) {
			str += '\'' + format_ + "' ";
		}
	}
	// smooth
	if (smooth_ >= 0) {
		str += "smooth " + SMOOTH[smooth_] + ' ';
	}
	return str;
}
