/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2009 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "plotrange.h"

PlotRange::PlotRange() : isParametric_(false)
{
	for (int i = 0; i < AXIS_NUM; i++) {
		dummyVarArray[i] = "";
		minArray[i] = "";
		maxArray[i] = "";
	}
}

void PlotRange::setParametric(bool isParametric)
{
	isParametric_ = isParametric;
}

bool PlotRange::isParametric() const
{
	return isParametric_;
}

void PlotRange::setDummyVariable(int axis, const QString &var)
{
	Q_ASSERT_X(axis >= 0 && axis < AXIS_NUM,
		"PlotRange::setDummyVariable", "index out of range");
	dummyVarArray[axis] = var;
}

const QString &PlotRange::dummyVariable(int axis) const
{
	Q_ASSERT_X(axis >= 0 && axis < AXIS_NUM,
		"PlotRange::dummyVariable", "index out of range");
	return dummyVarArray[axis];
}

void PlotRange::setMinimum(int axis, const QString &min)
{
	Q_ASSERT_X(axis >= 0 && axis < AXIS_NUM,
		"PlotRange::setMinimum", "index out of range");
	minArray[axis] = min;
}

const QString &PlotRange::minimum(int axis) const
{
	Q_ASSERT_X(axis >= 0 && axis < AXIS_NUM,
		"PlotRange::minimum", "index out of range");
	return minArray[axis];
}

void PlotRange::setMaximum(int axis, const QString &max)
{
	Q_ASSERT_X(axis >= 0 && axis < AXIS_NUM,
		"PlotRange::setMaximum", "index out of range");
	maxArray[axis] = max;
}

const QString &PlotRange::maximum(int axis) const
{
	Q_ASSERT_X(axis >= 0 && axis < AXIS_NUM,
		"PlotRange::maximum", "index out of range");
	return maxArray[axis];
}

QString PlotRange::option() const
{
	QString str;
	int beginNum = !isParametric_;
	int emptyNum = 0;
	for (int i = beginNum; i < AXIS_NUM; i++) {
		bool hasDummy = ((i == beginNum) && !dummyVarArray[i].isEmpty());
		bool hasEnd = (!minArray[i].isEmpty() || !maxArray[i].isEmpty());
		if (!hasDummy && !hasEnd) {
			emptyNum++;
			continue;
		}
		for (int j = 0; j < emptyNum; j++) {
			str += "[ ] ";
		}
		emptyNum = 0;
		str += '[';
		if (hasDummy) {
			str += dummyVarArray[i] + '=';
		}
		if (hasEnd) {
			str += minArray[i] + ':' + maxArray[i];
		}
		str += "] ";
	}
	return str;
}
