/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef PLOT_RANGE_INCLUDED
#define PLOT_RANGE_INCLUDED

#include <QtCore/QString>

#include "abstractcommandoption.h"

//! plot コマンドのオプション
class PlotRange : public AbstractCommandOption
{
	public:
		PlotRange();

		/*!
		 * \brief 媒介変数モードにするかどうかを設定する
		 * \param isParametric 媒介変数モードにするかどうか
		 */
		void setParametric(bool isParametric);
		/*!
		 * \brief 媒介変数モードにするかどうかを返す
		 * \return 媒介変数モードにするならば true
		 */
		bool isParametric() const;

		/*!
		 * \brief ダミー変数を設定する
		 * \param axis 設定する軸
		 * \param var 設定するダミー変数
		 * \note axis == 0 は媒介変数である。
		 */
		void setDummyVariable(int axis, const QString &var);
		/*!
		 * \brief ダミー変数を得る
		 * \param axis 軸
		 * \return ダミー変数
		 * \note axis == 0 は媒介変数である。
		 */
		const QString &dummyVariable(int axis) const;

		/*!
		 * \brief 最小値を設定する
		 * \param axis 設定する軸
		 * \param min 設定する最小値
		 * \note axis == 0 は媒介変数である。
		 */
		void setMinimum(int axis, const QString &min);
		/*!
		 * \brief 最小値を得る
		 * \param axis 軸
		 * \return 最小値
		 * \note axis == 0 は媒介変数である。
		 */
		const QString &minimum(int axis) const;

		/*!
		 * \brief 最大値を設定する
		 * \param axis 設定する軸
		 * \param max 設定する最大値
		 * \note axis == 0 は媒介変数である。
		 */
		void setMaximum(int axis, const QString &max);
		/*!
		 * \brief 最大値を得る
		 * \param axis 軸
		 * \return 最大値
		 * \note axis == 0 は媒介変数である。
		 */
		const QString &maximum(int axis) const;

		QString option() const;
	private:
		bool isParametric_;
		// 0 -> t, 1 -> x, 2 -> y
		static const int AXIS_NUM = 3;
		QString dummyVarArray[AXIS_NUM];
		QString minArray[AXIS_NUM];
		QString maxArray[AXIS_NUM];
};
#endif // PLOT_RANGE_INCLUDED
