/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "plotstyle.h"

const QString PlotStyle::STYLE[] = { "lines", "points", "linespoints",
	"impulses", "dots", "steps", "fsteps", "histeps", "errorbars",
	"xerrorbars", "yerrorbars", "xyerrorbars", "errorlines", 
	"xerrorlines", "yerrorlines", "boxes", "filledcurves",
	"boxerrorbars", "boxxyerrorbars", "financebars", "candlesticks",
	"vectors", ""
};

PlotStyle::PlotStyle() : style_(-1), lineType_(-1), lineWidth_(-1),
	pointType_(-1), pointSize_(-1), isPalette_(false)
{
}

void PlotStyle::setStyle(int style)
{
	style_ = style;
}

int PlotStyle::style() const
{
	return style_;
}

void PlotStyle::setLineType(int lt)
{
	lineType_ = lt;
}

int PlotStyle::lineType() const
{
	return lineType_;
}

void PlotStyle::setLineWidth(double lw)
{
	lineWidth_ = lw;
}

double PlotStyle::lineWidth() const
{
	return lineWidth_;
}

void PlotStyle::setPointType(int pt)
{
	pointType_ = pt;
}

int PlotStyle::pointType() const
{
	return pointType_;
}

void PlotStyle::setPointSize(double ps)
{
	pointSize_ = ps;
}

double PlotStyle::pointSize() const
{
	return pointSize_;
}

void PlotStyle::setFill(const QString &fs)
{
	fill_ = fs;
}

const QString &PlotStyle::fill() const
{
	return fill_;
}

void PlotStyle::setPalette(bool palette)
{
	isPalette_ = palette;
}

bool PlotStyle::isPalette() const
{
	return isPalette_;
}

QString PlotStyle::option() const
{
	QString str;
	if (style_ >= 0) {
		str += "with " + STYLE[style_] + ' ';
	}
	if (lineType_ >= 0) {
		str += "linetype " + QString::number(lineType_) + ' ';
	}
	if (lineWidth_ >= 0) {
		str += "linewidth " + QString::number(lineWidth_) + ' ';
	}
	if (pointType_ >= 0) {
		str += "pointtype " + QString::number(pointType_) + ' ';
	}
	if (pointSize_ >= 0) {
		str += "pointsize " + QString::number(pointSize_) + ' ';
	}
	if (!fill_.isEmpty()) {
		str += "fill " + fill_ + ' ';
	}
	if (isPalette_) {
		str += "palette";
	}
	return str;
}
