/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2009 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef PLOT_STYLE_INCLUDED
#define PLOT_STYLE_INCLUDED

#include <QtCore/QString>

#include "abstractcommandoption.h"

//! plot コマンドのオプション
class PlotStyle : public AbstractCommandOption
{
	public:
		PlotStyle();

		/*!
		 * \brief スタイルを設定する
		 * \param style 設定するスタイル
		 * \note 初期設定にするときは引数に負の数を指定する
		 * \sa PlotStyle::STYLE
		 */
		void setStyle(int style);
		/*!
		 * \brief スタイルを得る
		 * \return スタイル
		 * \note 初期設定のときは負の数を返す
		 * \sa PlotStyle::STYLE
		 */
		int style() const;

		/*!
		 * \brief 線の種類を設定する
		 * \param lt 設定する線の種類
		 * \note 初期設定にするときは引数に負の数を指定する
		 */
		void setLineType(int lt);
		/*!
		 * \brief 線の種類を得る
		 * \return 線の種類
		 * \note 初期設定のときは負の数を返す
		 */
		int lineType() const;

		/*!
		 * \brief 線の幅を設定する
		 * \param lw 設定する線の幅
		 * \note 初期設定にするときは引数に負の数を指定する
		 */
		void setLineWidth(double lw);
		/*!
		 * \brief 線の幅を得る
		 * \return 線の幅
		 * \note 初期設定のときは負の数を返す
		 */
		double lineWidth() const;

		/*!
		 * \brief 点の種類を設定する
		 * \param pt 設定する点の種類
		 * \note 初期設定にするときは引数に負の数を指定する
		 */
		void setPointType(int pt);
		/*!
		 * \brief 点の種類を得る
		 * \return 点の種類
		 * \note 初期設定のときは負の数を返す
		 */
		int pointType() const;

		/*!
		 * \brief 点のサイズを設定する
		 * \param ps 設定する点のサイズ
		 * \note 初期設定にするときは引数に負の数を指定する
		 */
		void setPointSize(double ps);
		/*!
		 * \brief 点のサイズを得る
		 * \return 点のサイズ
		 * \note 初期設定のときは負の数を返す
		 */
		double pointSize() const;

		/*!
		 * \brief 塗りつぶしのスタイルを設定する
		 * \param fs 設定する塗りつぶしのスタイル
		 */
		void setFill(const QString &fs);
		/*!
		 * \brief 塗りつぶしのスタイルを得る
		 * \return 塗りつぶしのスタイル
		 */
		const QString &fill() const;

		/*!
		 * \brief パレットを表示するかどうかを設定する
		 * \param palette パレットを表示するかどうか
		 */
		void setPalette(bool palette);
		/*!
		 * \brief パレットを表示するかどうかを返す
		 * \return パレットを表示するならば true
		 */
		bool isPalette() const;

		QString option() const;

		//! スタイル
		static const QString STYLE[];
	private:
		int style_;
		int lineType_;
		double lineWidth_;
		int pointType_;
		double pointSize_;
		QString fill_;
		bool isPalette_;
};

#endif // PLOT_STYLE_INCLUDED
