/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2008 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "consoledialog.h"

#include <QtCore/QCoreApplication>
#include <QtGui/QTextEdit>
#include <QtGui/QVBoxLayout>

ConsoleDialog::ConsoleDialog(QWidget *parent)
: QDialog(parent)
{
	setWindowTitle(tr("Console") + " - " 
			+ QCoreApplication::applicationName());

	consoleTextEdit = new QTextEdit;
	consoleTextEdit->setReadOnly(true);

	QVBoxLayout *mainLayout = new QVBoxLayout;
	mainLayout->addWidget(consoleTextEdit);

	setLayout(mainLayout);
}

void ConsoleDialog::execute(const QString &command)
{
	consoleTextEdit->append("<pre>" + Qt::escape(command) + "</pre>");
}

void ConsoleDialog::readStandardError(const QString &output)
{
	QString command = output;
	if (!command.trimmed().isEmpty()) {
		// エラー出力は赤で表示
		consoleTextEdit->append("<pre><font color=\"red\">" 
				+ Qt::escape(command) + "</font></pre>");
	}
}
