/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2008 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef FIT_BASIC_WIDGET_INCLUDED
#define FIT_BASIC_WIDGET_INCLUDED

#include <QtGui/QWidget>
class QLineEdit;
class QRadioButton;

class FileLineEdit;

class FitBasicWidget : public QWidget
{
	Q_OBJECT

	public:
		explicit FitBasicWidget(QWidget *parent = 0);

		void setFunctionName(const QString &functionName);
		QString functionName() const;

		void setFunction(const QString &function);
		QString function() const;

		void setDataFile(const QString &file);
		QString dataFile() const;

		void setParameterFile(bool isFile);
		bool isParameterFile() const;

		void setParameterFile(const QString &file);
		QString parameterFile() const;

		void setVariable(const QStringList &var);
		QStringList variable() const;

		bool canFit() const;

	private Q_SLOTS:
		//! データファイルを開く
		void openDataFile();
		//! パラメータファイルを開く
		void openParamFile();

	Q_SIGNALS:
		//! このシグナルはフィッティングの条件が変わったときに発信される
		void optionChanged();

	private:
		// don't implement these
		FitBasicWidget(const FitBasicWidget &);
		FitBasicWidget &operator=(const FitBasicWidget &);

		QLineEdit *nameLineEdit;
		QLineEdit *functionLineEdit;
		FileLineEdit *dataFileLineEdit;
		QRadioButton *paramFileRadioButton;
		FileLineEdit *paramFileLineEdit;
		QRadioButton *paramCSLRadioButton;
		QLineEdit *paramCSLLineEdit;
};
#endif // PLOT_BASIC_WIDGET_INCLUDED
