/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef FIT_OTHERS_WIDGET_INCLUDED
#define FIT_OTHERS_WIDGET_INCLUDED

#include <QtGui/QWidget>
class QDoubleSpinBox;
class QSpinBox;

class FitOthersWidget : public QWidget
{
	Q_OBJECT

	public:
		explicit FitOthersWidget(QWidget *parent = 0);

		void setLimit(double limit);
		double limit() const;

		void setMaxIter(int iter);
		int maxIter() const;

	private:
		// don't implement these
		FitOthersWidget(const FitOthersWidget &);
		FitOthersWidget &operator=(const FitOthersWidget &);

		QDoubleSpinBox *fitLimitMantissaDoubleSpinBox;
		QSpinBox *fitLimitExponentSpinBox;
		QSpinBox *fitMaxIterSpinBox;
};
#endif // PLOT_OTHERS_WIDGET_INCLUDED
