/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef FIT_RANGE_WIDGET_INCLUDED
#define FIT_RANGE_WIDGET_INCLUDED

#include <QtGui/QWidget>
class QLineEdit;

class FitRange;

class FitRangeWidget : public QWidget
{
	Q_OBJECT

	public:
		explicit FitRangeWidget(QWidget *parent = 0);

		void setRange(const FitRange &fitRange);
		FitRange range() const;

	private:
		// don't implement these
		FitRangeWidget(const FitRangeWidget &);
		FitRangeWidget &operator=(const FitRangeWidget &);

		static const int AXIS_NUM = 2;
		QLineEdit *dummyVariableLineEdit[AXIS_NUM];
		QLineEdit *minimumLineEdit[AXIS_NUM];
		QLineEdit *maximumLineEdit[AXIS_NUM];
};
#endif // PLOT_RANGE_WIDGET_INCLUDED
