/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2008 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef PLOT_INPUT_WIDGET_INCLUDED
#define PLOT_INPUT_WIDGET_INCLUDED

#include <QtGui/QWidget>
class QRadioButton;
class QLineEdit;

class FileLineEdit;
class Plot;

//! プロットする項目を入力するためのウィジェット
class PlotInputWidget : public QWidget
{
	Q_OBJECT

	public:
		explicit PlotInputWidget(QWidget *parent = 0);

		//! 文字列をコピーする
		void copy();
		//! 文字列を切り取る
		void cut();
		//! 文字列を貼り付ける
		void paste();
		//! すべての項目を選択する
		void selectAll();

	private Q_SLOTS:
		//! 項目を追加する
		void addData();
		//! データファイルを開く
		void openDataFile();
		//! 項目の追加元を切り替える
		void changeInput();

	Q_SIGNALS:
		/*!
		 * \brief このシグナルは項目が追加されるときに発信される
		 * \param plot 追加される Plot クラスのオブジェクト
		 */
		void dataAdded(const Plot &plot);
		/*!
		 * \brief このシグナルは項目の入力元が変更されるときに発信される
		 * \param notEmpty 新しい入力元の中に文字が含まれるときは true
		 */
		void inputChanged(bool notEmpty);

	private:
		// don't implement these
		PlotInputWidget(const PlotInputWidget &);
		PlotInputWidget &operator=(const PlotInputWidget &);

		/*!
		 * \brief フォーカスの当たっている QLineEdit オブジェクトを返す
		 * \return フォーカスの当たっている QLineEdit オブジェクト
		 *
		 * QLineEdit にフォーカスが当たっていなければ 0 を返す
		 */
		QLineEdit *focusLineEdit() const;

		QRadioButton *filenameRadioButton;
		FileLineEdit *filenameLineEdit;
		QRadioButton *functionRadioButton;
		QLineEdit *functionLineEdit;
};
#endif // PLOT_INPUT_WIDGET_INCLUDED
