/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2008, 2009 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "plotlistview.h"

#include <QtCore/QCoreApplication>
#if QT_VERSION >= 0x040200
# include <QtCore/QSettings>
# include <QtCore/QUrl>
# include <QtGui/QDesktopServices>
#endif
#include <QtGui/QAction>
#include <QtGui/QInputDialog>
#include <QtGui/QMenu>

#if QT_VERSION >= 0x040200
# include "misc.h"
#endif

PlotListView::PlotListView(QWidget *parent)
: QListView(parent)
{
#if QT_VERSION >= 0x040200
	QSettings settings;
	settings.beginGroup("PlotList");
	handler = settings.value("handler").toString();
	settings.endGroup();
	if (handler.isEmpty()) {
		QDesktopServices::unsetUrlHandler("file");
	} else {
		QDesktopServices::setUrlHandler("file", this, "setHandler");
	}
#endif
	editAction = new QAction(tr("&Edit..."), this);
	editAction->setIcon(QIcon(":/images/edit.png"));

#if QT_VERSION >= 0x040200
	openAction = new QAction(tr("&Open"), this);
#endif

	cutAction = new QAction(tr("C&ut"), this);
#if QT_VERSION >= 0x040200
	cutAction->setShortcut(QKeySequence::Cut);
#else
	cutAction->setShortcut(tr("Ctrl+X"));
#endif
	cutAction->setIcon(QIcon(":/images/editcut.png"));

	copyAction = new QAction(tr("&Copy"), this);
#if QT_VERSION >= 0x040200
	copyAction->setShortcut(QKeySequence::Copy);
#else
	copyAction->setShortcut(tr("Ctrl+C"));
#endif
	copyAction->setIcon(QIcon(":/images/editcopy.png"));

	pasteAction = new QAction(tr("&Paste"), this);
#if QT_VERSION >= 0x040200
	pasteAction->setShortcut(QKeySequence::Paste);
#else
	pasteAction->setShortcut(tr("Ctrl+V"));
#endif
	pasteAction->setIcon(QIcon(":/images/editpaste.png"));

	selectAllAction = new QAction(tr("Select &All"), this);
#if QT_VERSION >= 0x040200
	selectAllAction->setShortcut(QKeySequence::SelectAll);
#else
	selectAllAction->setShortcut(tr("Ctrl+A"));
#endif
}

void PlotListView::contextMenuEvent(QContextMenuEvent * /*event*/)
{
	QModelIndexList list = selectionModel()->selectedIndexes();
	int size = list.size();
	bool selected = !list.isEmpty();

	QMenu menu;

	editAction->setEnabled(size == 1);
	menu.addAction(editAction);

#if QT_VERSION >= 0x040200
	bool hasDataFile = false;
	for (int i = 0; i < size; i++) {
		if (!model()->data(list[i], Qt::UserRole + 1).toBool()) {
			hasDataFile = true;
			break;
		}
	}
	openAction->setEnabled(hasDataFile);
	menu.addAction(openAction);
#endif
	menu.addSeparator();

	cutAction->setEnabled(selected);
	menu.addAction(cutAction);

	copyAction->setEnabled(selected);
	menu.addAction(copyAction);

	menu.addAction(pasteAction);

	menu.addSeparator();

	selectAllAction->setEnabled(model()->rowCount());
	menu.addAction(selectAllAction);

	QAction *action = menu.exec(QCursor::pos());
	if (action == editAction) {
		bool ok;
		QString text 
			= QInputDialog::getText(this, tr("Edit") + " - " 
					+ QCoreApplication::applicationName(),
					tr("An Item Name:"), QLineEdit::Normal,
					model()->data(list[0]).toString(), &ok);
		// 文字列が空のときは変更しない
		if (ok && !text.isEmpty()) {
			model()->setData(list[0], QVariant(text));
		}
	} else
#if QT_VERSION >= 0x040200
	if (action == openAction) {
		for (int i = 0; i < size; i++) {
			if (!model()->data(list[i], Qt::UserRole + 1).toBool()) {
				::openDataFile(model()->data(list[i]).toString(), *this);
			}
		}
	} else
#endif
	if (action == cutAction) {
		cutRequested();
	} else if (action == copyAction) {
		copyRequested();
	} else if (action == pasteAction) {
		pasteRequested();
	} else if (action == selectAllAction) {
		selectAllRequested();
	}
}

#if QT_VERSION >= 0x040200
void PlotListView::setHandler(const QUrl &url)
{
	::openUrl(url, handler);
}
#endif
