/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2008, 2009 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef PLOT_LIST_VIEW_INCLUDED
#define PLOT_LIST_VIEW_INCLUDED

#include <QtGui/QListView>

//! プロットする項目を表示する List View
class PlotListView : public QListView
{
	Q_OBJECT

	public:
		explicit PlotListView(QWidget *parent = 0);

	private Q_SLOTS:
#if QT_VERSION >= 0x040200
		void setHandler(const QUrl &url);
#endif

	Q_SIGNALS:
		//! このシグナルは切り取るときに発信される
		void cutRequested();
		//! このシグナルはコピーするときに発信される
		void copyRequested();
		//! このシグナルは貼り付けるときに発信される
		void pasteRequested();
		//! このシグナルはすべての項目を選択するときに発信される
		void selectAllRequested();

	private:
		// don't implement these
		PlotListView(const PlotListView &);
		PlotListView &operator=(const PlotListView &);

		void contextMenuEvent(QContextMenuEvent *event);

#if QT_VERSION >= 0x040200
		QString handler;
#endif
		QAction *editAction;
#if QT_VERSION >= 0x040200
		QAction *openAction;
#endif
		QAction *cutAction;
		QAction *copyAction;
		QAction *pasteAction;
		QAction *selectAllAction;
};
#endif // PLOT_LIST_VIEW_INCLUDED
