/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2008 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef PLOT_MIME_DATA_INCLUDED
#define PLOT_MIME_DATA_INCLUDED

#include <QtCore/QMimeData>

#include "plot.h"

//! Plot クラスのリストを保持するように QMimeData を拡張したクラス
class PlotMimeData : public QMimeData {
	Q_OBJECT

	public:
		void setPlotList(const QList<Plot> &list) { plotList_ = list; }
		const QList<Plot> &plotList() const { return plotList_; }
	private:
		QList<Plot> plotList_;
};
#endif // PLOT_MIME_DATA_INCLUDED
