/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2008 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "misc.h"
#if QT_VERSION >= 0x040200

#include <QtCore/QCoreApplication>
#include <QtCore/QFileInfo>
#include <QtCore/QProcess>
#include <QtCore/QStringList>
#include <QtCore/QUrl>
#include <QtCore/QSettings>
#include <QtGui/QDesktopServices>
#include <QtGui/QMessageBox>

#include "plotlistview.h"

void openDataFile(const QString &file, QWidget &widget)
{
	// 実行可能ファイルの実行を防ぐ
	if (QSettings().value("PlotList/handler").toString().isEmpty() 
			&& QFileInfo(file).isExecutable()) {
		QMessageBox::critical(&widget, PlotListView::tr("Executable File") 
				+ " - " + QCoreApplication::applicationName(), 
				PlotListView::tr("The file '%1' is an executable file.")
				.arg(file));
		return;
	}
	if (!QDesktopServices::openUrl(QUrl::fromLocalFile(file))) {
		QMessageBox::critical(&widget, PlotListView::tr("Error") + " - "
			+ QCoreApplication::applicationName(), 
			PlotListView::tr("The file '%1' could not be opened.").arg(file));
	}
}

void openUrl(const QUrl &url, const QString &handler)
{
#if defined(Q_OS_DARWIN)
	QStringList argument;
	argument << "-a" << handler << url.toLocalFile();
	QProcess::startDetached("open", argument);
#else
	QProcess::startDetached(handler, QStringList(url.toLocalFile()));
#endif
}
#endif // QT_VERSION >= 0x040200
