/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2008 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef MISC_INCLUDED
#define MISC_INCLUDED

#include <QtGlobal>
#if QT_VERSION >= 0x040200
class QString;
class QUrl;
class QWidget;

/*!
 * \brief データファイルを開く
 * \param file 開くデータファイル
 * \param widget メッセージボックスの親ウィジェット
 */
void openDataFile(const QString &file, QWidget &widget);

/*!
 * \brief 指定した URL に対応するファイルを開く
 * \param url 開く URL
 * \param handler 開く際に用いるアプリケーション
 */
void openUrl(const QUrl &url, const QString &handler);
#endif // QT_VERSION >= 0x040200

#endif // MISC_INCLUDED
