/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2008 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef ABSTRACT_OPTION_WIDGET_INCLUDED
#define ABSTRACT_OPTION_WIDGET_INCLUDED

#include <QtGui/QWidget>

//! set コマンドのオプションを扱うウィジェット
class AbstractOptionWidget : public QWidget
{
	Q_OBJECT

	public:
		explicit AbstractOptionWidget(QWidget *parent = 0) : QWidget(parent) { }
		virtual ~AbstractOptionWidget() { }

		//! ウィジェット内の要素を構築する
		virtual void construct() = 0;
		//! ウィジェットを初期化する
		virtual void init() = 0;
		//! ウィジェットの状態をもとにコマンドを実行する
		virtual void apply() = 0;
		//! ウィジェットの状態の変化を破棄する
		void discard() { setWidget(); }

	Q_SIGNALS:
		/*! 
		 * \brief コマンドを実行する
		 * \param command 実行するコマンド
		 */
		void executed(const QString &command);
		void modified();

	protected:
		//! メンバ変数のオブジェクトの状態からウィジェットの状態を設定する
		virtual void setWidget() = 0;

	private:
		// don't implement these
		AbstractOptionWidget(const AbstractOptionWidget &);
		AbstractOptionWidget &operator=(const AbstractOptionWidget &);
};

#endif // ABSTRACT_OPTION_WIDGET_INCLUDED
