/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2008 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "axisrangeoptionwidget.h"

#include <QtGui/QComboBox>
#include <QtGui/QLabel>
#include <QtGui/QLineEdit>
#include <QtGui/QGridLayout>

#include "axisrange.h"

AxisRangeOptionWidget::AxisRangeOptionWidget(QWidget *parent)
: AxisOptionWidget(parent), axisRange(0)
{
	setWindowTitle(tr("Range"));
}

AxisRangeOptionWidget::~AxisRangeOptionWidget()
{
	delete axisRange;
}

void AxisRangeOptionWidget::init()
{
	delete axisRange;
	axisRange = new AxisRange;
	setWidget();
}

void AxisRangeOptionWidget::construct()
{
	setWhatsThis(tr("set &lt;axis&gt;range"));

	AxisOptionWidget::construct();
	for (int i = 0; !AxisRange::AXIS[i].isEmpty(); i++) {
		axisComboBox->addItem(AxisRange::AXIS[i]);
	}
}

void AxisRangeOptionWidget::apply()
{
	AxisOptionWidget::apply();
	emit executed(axisRange->command());
}

void AxisRangeOptionWidget::constructWidget(QWidget *widget)
{
	minLineEdit = new QLineEdit;
	connect(minLineEdit, SIGNAL(textChanged(const QString &)),
			this, SIGNAL(modified()));

	QLabel *minLabel = new QLabel;
	minLabel->setText(tr("&Minimum:"));
	minLabel->setBuddy(minLineEdit);

	maxLineEdit = new QLineEdit;
	connect(maxLineEdit, SIGNAL(textChanged(const QString &)),
			this, SIGNAL(modified()));

	QLabel *maxLabel = new QLabel;
	maxLabel->setText(tr("Max&imum:"));
	maxLabel->setBuddy(maxLineEdit);

	QGridLayout *mainLayout = new QGridLayout;
	mainLayout->addWidget(minLabel, 0, 0);
	mainLayout->addWidget(minLineEdit, 0, 1);
	mainLayout->addItem(new QSpacerItem(0, 0,
				QSizePolicy::Expanding, QSizePolicy::Minimum), 0, 2);
	mainLayout->addWidget(maxLabel, 1, 0);
	mainLayout->addWidget(maxLineEdit, 1, 1);
	mainLayout->addItem(new QSpacerItem(0, 0,
				QSizePolicy::Minimum, QSizePolicy::Expanding), 2, 0);

	widget->setLayout(mainLayout);
}


void AxisRangeOptionWidget::setOption(int axis)
{
	axisRange->setMinimum(axis, minLineEdit->text());
	axisRange->setMaximum(axis, maxLineEdit->text());
}

void AxisRangeOptionWidget::setAxisWidget(int axis)
{
	minLineEdit->setText(axisRange->minimum(axis));
	maxLineEdit->setText(axisRange->maximum(axis));
}
