/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef GRID_OPTION_WIDGET_INCLUDED
#define GRID_OPTION_WIDGET_INCLUDED

#include <QtCore/QList>
class QCheckBox;

#include "abstractoptionwidget.h"
class Grid;

//! set grid コマンドのオプションを扱うウィジェット
class GridOptionWidget : public AbstractOptionWidget
{
	Q_OBJECT

	public:
		explicit GridOptionWidget(QWidget *parent = 0);
		~GridOptionWidget();

		void construct();

	private:
		// don't implement these
		GridOptionWidget(const GridOptionWidget &);
		GridOptionWidget &operator=(const GridOptionWidget &);

		void init();
		void apply();
		void setWidget();
		Grid *grid;
		QList<QCheckBox *> gridCheckBoxList;
};
#endif // GRID_OPTION_WIDGET_INCLUDED
