/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2008 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "mappingoptionwidget.h"

#include <QtCore/QCoreApplication>
#include <QtGui/QGridLayout>
#include <QtGui/QComboBox>

#include "mapping.h"

MappingOptionWidget::MappingOptionWidget(QWidget *parent)
: AbstractOptionWidget(parent), mapping(0)
{
	setWindowTitle(tr("Coordinate"));
}

MappingOptionWidget::~MappingOptionWidget()
{
	delete mapping;
}

void MappingOptionWidget::construct()
{
	setWhatsThis("set mapping");

	coordComboBox = new QComboBox;
	for (int i = 0; Mapping::COORDINATE[i][0]; i++) {
		coordComboBox->addItem(QCoreApplication::translate(
					"Mapping", Mapping::COORDINATE[i]));
	}
	connect(coordComboBox, SIGNAL(activated(int)),
			this, SIGNAL(modified()));

	QGridLayout *mainLayout = new QGridLayout;
	mainLayout->addWidget(coordComboBox, 0, 0);
	mainLayout->addItem(new QSpacerItem(0, 0, 
				QSizePolicy::Expanding, QSizePolicy::Minimum), 0, 1);
	mainLayout->addItem(new QSpacerItem(0, 0,
				QSizePolicy::Minimum, QSizePolicy::Expanding), 1, 0);

	setLayout(mainLayout);
}

void MappingOptionWidget::init()
{
	delete mapping;
	mapping = new Mapping;
	setWidget();
}

void MappingOptionWidget::apply()
{
	mapping->setCoordinate(coordComboBox->currentIndex());
	emit executed(mapping->command());
}

void MappingOptionWidget::setWidget()
{
	coordComboBox->setCurrentIndex(mapping->coordinate());
}
