/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2008 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "outputoptionwidget.h"

#include <QtCore/QCoreApplication>
#include <QtGui/QFileDialog>
#include <QtGui/QGroupBox>
#include <QtGui/QHBoxLayout>
#include <QtGui/QPushButton>
#include <QtGui/QVBoxLayout>

#include "filelineedit.h"
#include "output.h"

OutputOptionWidget::OutputOptionWidget(QWidget *parent)
: AbstractOptionWidget(parent), output(0)
{
	setWindowTitle(tr("Output"));
}

OutputOptionWidget::~OutputOptionWidget()
{
	delete output;
}

void OutputOptionWidget::construct()
{
	setWhatsThis("set output");

	fileLineEdit = new FileLineEdit("set_output");
	connect(fileLineEdit, SIGNAL(textChanged(const QString &)),
			this, SIGNAL(modified()));

	fileNamePushButton = new QPushButton;
	fileNamePushButton->setText(tr("O&pen..."));
	connect(fileNamePushButton, SIGNAL(clicked(bool)),
			this, SLOT(setOutput()));

	QHBoxLayout *outputLayout = new QHBoxLayout;
	outputLayout->addWidget(fileLineEdit);
	outputLayout->addWidget(fileNamePushButton);

	defaultGroupBox = new QGroupBox;
	defaultGroupBox->setLayout(outputLayout);
	defaultGroupBox->setTitle(tr("&Specify"));
	defaultGroupBox->setCheckable(true);
	connect(defaultGroupBox, SIGNAL(toggled(bool)),
			this, SIGNAL(modified()));
	connect(defaultGroupBox, SIGNAL(toggled(bool)),
			fileLineEdit, SLOT(setEnabled(bool)));
	connect(defaultGroupBox, SIGNAL(toggled(bool)),
			fileNamePushButton, SLOT(setEnabled(bool)));

	QVBoxLayout *mainLayout = new QVBoxLayout;
	mainLayout->addWidget(defaultGroupBox);
	mainLayout->addStretch();

	setLayout(mainLayout);
}

void OutputOptionWidget::init()
{
	delete output;
	output = new Output;
	setWidget();
}

void OutputOptionWidget::apply()
{
	QString name = defaultGroupBox->isChecked() ? fileLineEdit->text() : "";
	output->setFileName(name);
	emit executed(output->command());
}

void OutputOptionWidget::setWidget()
{
	QString fileName = output->fileName();
	bool isEmpty = fileName.isEmpty();
	defaultGroupBox->setChecked(!isEmpty);
	fileLineEdit->setText(fileName);
	fileLineEdit->setEnabled(!isEmpty);
	fileNamePushButton->setEnabled(!isEmpty);
}

void OutputOptionWidget::setOutput()
{
	QString file = QFileDialog::getSaveFileName(this, tr("Set output") + " - " 
			+ QCoreApplication::applicationName(), fileLineEdit->file());
	if (!file.isNull()) {
		fileLineEdit->setFile(file);
	}
}
