/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2008 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef OUTPUT_OPTION_WIDGET_INCLUDED
#define OUTPUT_OPTION_WIDGET_INCLUDED

class QGroupBox;
class QPushButton;

#include "abstractoptionwidget.h"
class FileLineEdit;
class Output;

// set output コマンドのオプションを扱うウィジェット
class OutputOptionWidget : public AbstractOptionWidget
{
	Q_OBJECT

	public:
		explicit OutputOptionWidget(QWidget *parent = 0);
		~OutputOptionWidget();

		void construct();

	private Q_SLOTS:
		void setOutput();

	private:
		// don't implement these
		OutputOptionWidget(const OutputOptionWidget &);
		OutputOptionWidget &operator=(const OutputOptionWidget &);

		void init();
		void apply();
		void setWidget();
		Output *output;
		QGroupBox *defaultGroupBox;
		FileLineEdit *fileLineEdit;
		QPushButton *fileNamePushButton;
};
#endif // OUTPUT_OPTION_WIDGET_INCLUDED
