/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef STYLE_DATA_OPTION_WIDGET_INCLUDED
#define STYLE_DATA_OPTION_WIDGET_INCLUDED

class QComboBox;

#include "abstractoptionwidget.h"
class StyleData;

//! set style data コマンドのオプションを扱うウィジェット
class StyleDataOptionWidget : public AbstractOptionWidget
{
	Q_OBJECT

	public:
		explicit StyleDataOptionWidget(QWidget *parent = 0);
		~StyleDataOptionWidget();

		void construct();

	private:
		// don't implement these
		StyleDataOptionWidget(const StyleDataOptionWidget &);
		StyleDataOptionWidget &operator=(const StyleDataOptionWidget &);

		void init();
		void apply();
		void setWidget();
		StyleData *styleData;
		QComboBox *styleComboBox;
};
#endif // STYLE_DATA_OPTION_WIDGET_INCLUDED
