/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2008 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "styleoptionwidget.h"

#include <QtGui/QComboBox>
#include <QtGui/QHBoxLayout>
#include <QtGui/QPushButton>
#include <QtGui/QScrollArea>
#include <QtGui/QStackedWidget>
#include <QtGui/QVBoxLayout>

#include "styledataoptionwidget.h"
#include "stylefilloptionwidget.h"
#include "stylefunctionoptionwidget.h"

StyleOptionWidget::StyleOptionWidget(QWidget *parent)
: AbstractOptionWidget(parent)
{
	setWindowTitle(tr("Style"));
}

void StyleOptionWidget::construct()
{
	setWhatsThis("set style");

	typeComboBox = new QComboBox;
	typeComboBox->addItem(tr("Function"));
	typeComboBox->addItem(tr("Data"));
	typeComboBox->addItem(tr("Fill"));
	connect(typeComboBox, SIGNAL(activated(int)),
			this, SLOT(changeType(int)));

	typeStackedWidget = new QStackedWidget;
	typeStackedWidget->addWidget(new StyleFunctionOptionWidget);
	typeStackedWidget->addWidget(new StyleDataOptionWidget);
	typeStackedWidget->addWidget(new StyleFillOptionWidget);

	initBitArray.resize(typeStackedWidget->count());

	initPushButton = new QPushButton;
	initPushButton->setText(tr("&Initialize Options"));
	connect(initPushButton, SIGNAL(clicked()),
			this, SLOT(initOption()));
	changeType(0);

	QScrollArea *scrollArea = new QScrollArea;
	scrollArea->setWidget(typeStackedWidget);
	scrollArea->setWidgetResizable(true);
	scrollArea->setFrameShadow(QFrame::Plain);
	scrollArea->setFrameShape(QFrame::NoFrame);

	QHBoxLayout *buttonLayout = new QHBoxLayout;
	buttonLayout->addStretch();
	buttonLayout->addWidget(initPushButton);

	QVBoxLayout *mainLayout = new QVBoxLayout;
	mainLayout->addWidget(typeComboBox);
	mainLayout->addWidget(scrollArea);
	mainLayout->addLayout(buttonLayout);

	setLayout(mainLayout);
}

void StyleOptionWidget::init()
{
	for (int i = 0, j = initBitArray.size(); i < j; i++) {
		if (initBitArray.at(i)) {
			qobject_cast<AbstractOptionWidget *>(typeStackedWidget->widget(i))
				->init();
		}
	}
}

void StyleOptionWidget::initOption()
{
	qobject_cast<AbstractOptionWidget *>(typeStackedWidget->currentWidget())
		->init();
}

void StyleOptionWidget::apply()
{
	for (int i = 0, j = initBitArray.size(); i < j; i++) {
		if (initBitArray.at(i)) {
			qobject_cast<AbstractOptionWidget *>(typeStackedWidget->widget(i))
				->apply();
		}
	}
}

void StyleOptionWidget::setWidget()
{
	for (int i = 0, j = initBitArray.size(); i < j; i++) {
		if (initBitArray.at(i)) {
			qobject_cast<AbstractOptionWidget *>(typeStackedWidget->widget(i))
				->discard();
		}
	}
}

void StyleOptionWidget::changeType(int index)
{
	if (!initBitArray.at(index)) {
		AbstractOptionWidget *optionWidget =
			qobject_cast<AbstractOptionWidget *>(typeStackedWidget->widget(index));
		optionWidget->construct();
		optionWidget->init();
		connect(optionWidget, SIGNAL(executed(const QString &)),
				this, SIGNAL(executed(const QString &)));
		connect(optionWidget, SIGNAL(modified()),
				this, SIGNAL(modified()));
		initBitArray.setBit(index);
	}
	typeStackedWidget->setCurrentIndex(index);
}
