/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2008, 2009 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef OPTION_DIALOG_INCLUDED
#define OPTION_DIALOG_INCLUDED

#include <QtCore/QBitArray>
#include <QtGui/QDialog>
class QCloseEvent;
class QLabel;
class QListWidget;
class QListWidgetItem;
class QDialog;
class QStackedWidget;

class AbstractOptionWidget;

//! set コマンドを実行するダイアログ (Singleton)
class OptionDialog : public QDialog
{
	Q_OBJECT

	public:
		static OptionDialog &instance(QWidget *parent = 0);
		static void destroyInstance();

    private Q_SLOTS:
		//! 設定を適用してダイアログを閉じる
		void accept();
		//! 設定を適用する
		void apply();
		//! 設定を破棄してダイアログを閉じる
		void reject();
		//! 設定を初期化する
		void init();
		/*!
		 * \brief 表示する項目を変える
		 * \param current 現在の項目
		 * \param previous 前の項目
		 */
		void changePage(QListWidgetItem *current, QListWidgetItem *previous);
		//! 設定に変更が加えられたことにする
		void setModified();

	Q_SIGNALS:
		/*! 
		 * \brief このシグナルはコマンドを実行するときに発信される
		 * \param command 実行するコマンド
		 */
		void executed(const QString &command);

	private:
		OptionDialog(QWidget *parent = 0);
		// don't implement these
		OptionDialog(const OptionDialog &);
		OptionDialog &operator=(const OptionDialog &);

		/*!
		 * \brief 変更を破棄する
		 * \param optionWidget 変更を破棄させるウィジェット
		 */
		void discard(AbstractOptionWidget *optionWidget);
		//! ダイアログを閉じるときの処理をする
		void closeEvent(QCloseEvent *e);
		static OptionDialog *instance_;
		QLabel *headerLabel;
		QListWidget *contentsListWidget;
		QStackedWidget *pagesStackedWidget;
		//! 設定項目のウィジェットが初期化済みか調べるのに使う配列
		QBitArray initBitArray;
};

#endif // OPTION_DIALOG_INCLUDED
