/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2008, 2009 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef PLOT_MODIFIER_WIDGET_INCLUDED
#define PLOT_MODIFIER_WIDGET_INCLUDED

#include "abstractplotoptionwidget.h"
class PlotModifier;

#include <QtCore/QList>
class QCheckBox;
class QComboBox;
class QLineEdit;
class QSpinBox;

//! プロットする項目のデータファイル関係のオプションを表示するウィジェット
class PlotModifierWidget : public AbstractPlotOptionWidget
{
	Q_OBJECT

	public:
		explicit PlotModifierWidget(QWidget *parent = 0);
		~PlotModifierWidget();

		void setModifier(const QList<PlotModifier> &list);
		const QList<PlotModifier> &modifier() const;

		void apply();

	private Q_SLOTS:
		//! チェックボックスの状態に応じて他のチェックボックスの状態を変える
		void setIndex();

	private:
		// don't implement these
		PlotModifierWidget(const PlotModifierWidget &);
		PlotModifierWidget &operator=(const PlotModifierWidget &);

		void setWidget();
		//! 指定されたインデックスに応じてウィジェットの状態を設定する
		void setIndexWidget();
		//! 指定されたサンプリングに応じてウィジェットの状態を設定する
		void setSamplingWidget();
		//! 指定された列に応じてウィジェットの状態を設定する
		void setColumnWidget();
		//! 指定された平滑化に応じてウィジェットの状態を設定する
		void setSmoothingWidget();
		//! PlotModifier オブジェクトが保持するインデックスの値を返す
		int index(const PlotModifier &plotModifier, int num) const;
		//! PlotModifier オブジェクトが保持するサンプリングの値を返す
		int sampling(const PlotModifier &plotModifier, int num) const;

		static const int AXIS_NUM = 3;
		QList<PlotModifier> plotModifierList;
		QCheckBox *columnCheckBox[AXIS_NUM];
		QLineEdit *columnLineEdit[AXIS_NUM];
		QCheckBox *formatCheckBox;
		QLineEdit *formatLineEdit;
		QList<QCheckBox *> indexCheckBoxList;
		QList<QSpinBox *> indexSpinBoxList;
		QList<QCheckBox *> samplingCheckBoxList;
		QList<QSpinBox *> samplingSpinBoxList;
		QCheckBox *interpCheckBox;
		QComboBox *interpComboBox;
};
#endif // PLOT_MODIFIER_WIDGET_INCLUDED
