/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2008, 2009 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "plototherswidget.h"

#include <QtGui/QComboBox>
#include <QtGui/QGroupBox>
#include <QtGui/QHBoxLayout>
#include <QtGui/QVBoxLayout>

#include "plot.h"

PlotOthersWidget::PlotOthersWidget(QWidget *parent)
: AbstractPlotOptionWidget(parent)
{
	setWindowTitle(tr("Others"));

	axisComboBox = new QComboBox;
	for (int i = 0; !Plot::AXIS[i].isEmpty(); i++) {
		axisComboBox->addItem(Plot::AXIS[i]);
	}
	connect(axisComboBox, SIGNAL(activated(int)),
			this, SIGNAL(modified()));

	QHBoxLayout *axisLayout = new QHBoxLayout;
	axisLayout->addWidget(axisComboBox);
	axisLayout->addStretch();

	axisGroupBox = new QGroupBox(tr("A&xes"));
	axisGroupBox->setWhatsThis(tr("plot {axes &lt;axes&gt;}"));
	axisGroupBox->setCheckable(true);
	axisGroupBox->setLayout(axisLayout);
	connect(axisGroupBox, SIGNAL(toggled(bool)),
			this, SIGNAL(modified()));
	connect(axisGroupBox, SIGNAL(toggled(bool)),
			axisComboBox, SLOT(setEnabled(bool)));

	QVBoxLayout *mainLayout = new QVBoxLayout;
	mainLayout->addWidget(axisGroupBox);
	mainLayout->addStretch();

	setLayout(mainLayout);
}

void PlotOthersWidget::setAxis(const QList<int> &list)
{
	axisList = list;
	setWidget();
}

const QList<int> &PlotOthersWidget::axis() const
{
	return axisList;
}

void PlotOthersWidget::apply()
{
	bool isChecked = axisGroupBox->isChecked();
	int axis = isChecked ? axisComboBox->currentIndex() : -1;
	bool hasAxis = (!isChecked || axis >= 0);
	for (int i = 0, j = axisList.size(); i < j; i++) {
		if (hasAxis) {
			axisList[i] = axis;
		}
	}
}

void PlotOthersWidget::setWidget()
{
	int axis = axisList[0];
	for (int i = 1, j = axisList.size(); i < j; i++) {
		if (axisList[i] != axis) {
			axisGroupBox->setChecked(true);
			axisComboBox->setEnabled(true);
			axisComboBox->setCurrentIndex(-1);
			return;
		}
	}
	bool hasAxis = (axis >= 0);
	axisGroupBox->setChecked(hasAxis);
	axisComboBox->setEnabled(hasAxis);
	if (hasAxis) {
		axisComboBox->setCurrentIndex(axis);
	}
}
