/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef PLOT_OTHERS_WIDGET_INCLUDED
#define PLOT_OTHERS_WIDGET_INCLUDED

class QComboBox;
class QGroupBox;

#include "abstractplotoptionwidget.h"

//! プロットする項目のその他のオプションを表示するウィジェット
class PlotOthersWidget : public AbstractPlotOptionWidget
{
	Q_OBJECT

	public:
		explicit PlotOthersWidget(QWidget *parent = 0);

		void setAxis(const QList<int> &axis);
		const QList<int> &axis() const;

		void apply();

	private:
		// don't implement these
		PlotOthersWidget(const PlotOthersWidget &);
		PlotOthersWidget &operator=(const PlotOthersWidget &);

		void setWidget();

		QList<int> axisList;
		QComboBox *axisComboBox;
		QGroupBox *axisGroupBox;
};
#endif // PLOT_OTHERS_WIDGET_INCLUDED
