/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef PLOT_STYLE_WIDGET_INCLUDED
#define PLOT_STYLE_WIDGET_INCLUDED

class QCheckBox;
class QComboBox;
class QDoubleSpinBox;
class QSpinBox;

#include "abstractplotoptionwidget.h"
#include "plotstyle.h"

//! プロットする項目のスタイルを表示するウィジェット
class PlotStyleWidget : public AbstractPlotOptionWidget
{
	Q_OBJECT

	public:
		explicit PlotStyleWidget(QWidget *parent = 0);

		void setStyle(const QList<PlotStyle> &list);
		const QList<PlotStyle> &style() const;

		void apply();

	private:
		// don't implement these
		PlotStyleWidget(const PlotStyleWidget &);
		PlotStyleWidget &operator=(const PlotStyleWidget &);

		void setWidget();
		//! 指定されたスタイルに応じてウィジェットの状態を設定する
		void setStyleWidget();
		//! 指定された線の種類に応じてウィジェットの状態を設定する
		void setLineTypeWidget();
		//! 指定された線の幅に応じてウィジェットの状態を設定する
		void setLineWidthWidget();
		//! 指定された点の種類に応じてウィジェットの状態を設定する
		void setPointTypeWidget();
		//! 指定された点のサイズに応じてウィジェットの状態を設定する
		void setPointSizeWidget();

		QList<PlotStyle> plotStyleList;
		QCheckBox *styleCheckBox;
		QComboBox *styleComboBox;
		QCheckBox *lineTypeCheckBox;
		QSpinBox *lineTypeSpinBox;
		QCheckBox *lineWidthCheckBox;
		QDoubleSpinBox *lineWidthDoubleSpinBox;
		QCheckBox *pointTypeCheckBox;
		QSpinBox *pointTypeSpinBox;
		QCheckBox *pointSizeCheckBox;
		QDoubleSpinBox *pointSizeDoubleSpinBox;
};
#endif // PLOT_STYLE_WIDGET_INCLUDED
