/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef PLOT_TITLE_WIDGET_INCLUDED
#define PLOT_TITLE_WIDGET_INCLUDED

class QLineEdit;
class QRadioButton;

#include "abstractplotoptionwidget.h"
#include "plottitle.h"
class PlotTitle;

//! プロットする項目のタイトルを表示するウィジェット
class PlotTitleWidget : public AbstractPlotOptionWidget
{
	Q_OBJECT

	public:
		explicit PlotTitleWidget(QWidget *parent = 0);

		void setTitle(const QList<PlotTitle> &list);
		const QList<PlotTitle> &title() const;

		void apply();

	private:
		// don't implement these
		PlotTitleWidget(const PlotTitleWidget &);
		PlotTitleWidget &operator=(const PlotTitleWidget &);

		void setWidget();

		QList<PlotTitle> plotTitleList;
		QRadioButton *defaultTitleRadioButton;
		QRadioButton *noTitleRadioButton;
		QRadioButton *customTitleRadioButton;
		QLineEdit *titleLineEdit;
};
#endif // PLOT_TITLE_WIDGET_INCLUDED
