/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef PROCESS_INCLUDED
#define PROCESS_INCLUDED

#include <QtCore/QObject>
class QProcess;
class QString;
class QTextCodec;

class ConsoleDialog;

//! gnuplot のプロセスを扱うクラス
class Process : public QObject
{
	Q_OBJECT

	public:
		explicit Process(QObject *parent = 0);

		//! コンソールダイアログを閉じる
		void closeDialog();
		/*!
		 * \brief コンソールダイアログの表示/非表示を設定する
		 * \param visible 表示させるときは true
		 */
		void setDialogVisible(bool visible);
		/*!
		 * \brief コンソールダイアログが表示されているのかを返す
		 * \return 表示されているときは true
		 */
		bool isDialogVisible();

		//! gnuplot のファイル名
		const static QString FILE_NAME;

	public Q_SLOTS:
		/*! 
		 * \brief コマンドを実行する
		 * \param command 実行するコマンド
		 */
		void execute(const QString &command);

	private Q_SLOTS:
		//! エラーメッセージを読み込む
		void readStandardError();

	private:
		// don't implement these 
		Process(const Process &);
		Process &operator=(const Process &);

		/*! 
		 * \brief gnuplot のプロセスを起動する
		 * \return 起動に成功したら true
		 */
		bool startProcess();
		/*! 
		 * \brief 起動できるか調べる
		 * \param path gnuplot のパス
		 * \return 起動できたら true
		 */
		bool canStart(const QString &path);

		//! gnuplot のプロセス
		QProcess *process;
		//! 入力されたコマンドやエラー出力を表示するダイアログ
		ConsoleDialog *consoleDialog;
		//! テキストのエンコーディング変換に使うコーデック
		QTextCodec *textCodec;
};

#endif // PROCESS_INCLUDED
