/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef RAW_COMMAND_DIALOG_INCLUDED
#define RAW_COMMAND_DIALOG_INCLUDED

#include <QtGui/QDialog>
class QTextEdit;

//! コマンドをそのまま gnuplot に対して送るためのダイアログ (Singleton)
class RawCommandDialog : public QDialog
{
	Q_OBJECT

	public:
		static RawCommandDialog &instance(QWidget *parent = 0);
		static void destroyInstance();

	private Q_SLOTS:
		//! テキストエディッタが空かどうかで実行ボタンの状態を設定する
		void setButton();

	Q_SIGNALS:
		/*!
		 * \brief このシグナルはコマンドを実行するときに発信される
		 * \param command 実行するコマンド
		 */
		void executed(const QString &command);

	private:
		RawCommandDialog(QWidget *parent = 0);
		// don't implement these
		RawCommandDialog(const RawCommandDialog &);
		RawCommandDialog &operator=(const RawCommandDialog &);

		//! テキストエディト内のコマンドを実行する
		void accept();
		static RawCommandDialog *instance_;
		QTextEdit *rawTextEdit;
		QPushButton *execPushButton;
};
#endif // RAW_COMMAND_DIALOG_INCLUDED
